<?php
session_start();
include 'conexao.php';

// Verifica se o ID do pagamento foi passado na URL e se é um número válido.
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("ID de pagamento inválido.");
}

$id_pagamento = intval($_GET['id']);

// Consulta do pagamento e dos dados do aluno e da turma.
$sql = "SELECT 
            p.*, 
            a.nome AS nome_aluno, 
            t.nome AS nome_turma,
            t.curso AS curso_turma,
            t.sala AS sala_turma,
            t.classe AS classe_turma
        FROM 
            propinas p
        JOIN 
            alunos a ON p.aluno_id = a.id
        JOIN
            turmas t ON a.turma_id = t.id
        WHERE 
            p.id = ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id_pagamento);
$stmt->execute();
$result = $stmt->get_result();

// Se nenhum resultado for encontrado, interrompe a execução e exibe uma mensagem.
if ($result->num_rows === 0) {
    die("Pagamento não encontrado ou dados da turma ausentes.");
}

// Pega a linha do resultado como um array associativo.
$dados = $result->fetch_assoc();

// Fecha o statement e a conexão com o banco de dados.
$stmt->close();
$conn->close();

?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Recibo de Propina</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 40px;
            background: #f4f4f4;
        }
        .recibo {
            background: #fff;
            border: 2px solid #003366;
            padding: 30px;
            max-width: 750px;
            margin: auto;
            box-shadow: 0 2px 8px rgba(0,0,0,0.2);
        }
        .cabecalho-escola {
            text-align: center;
            color: #003366;
            margin-bottom: 15px;
            font-weight: bold;
            font-size: 16px;
        }
        .recibo img.logo {
            display: block;
            margin: 0 auto 10px auto;
            max-height: 80px;
        }
        h2 {
            text-align: center;
            color: #003366;
            margin-bottom: 30px;
            font-size: 22px;
        }
        .linha {
            margin-bottom: 12px;
            font-size: 16px;
        }
        .linha strong {
            color: #003366;
        }
        .assinatura {
            margin-top: 40px;
            text-align: right;
        }
        .assinatura p {
            border-top: 1px solid #333;
            display: inline-block;
            padding-top: 5px;
            width: 220px;
        }
        .assinatura p .texto-ass {
            /* Novo estilo para mover apenas a frase */
            position: relative; 
            left: -20px; /* VALOR AJUSTADO */
        }
        .botoes {
            text-align: center;
            margin-top: 30px;
        }
        .botoes button,
        .botoes a {
            padding: 10px 20px;
            background-color: #003366;
            color: white;
            border: none;
            border-radius: 4px;
            text-decoration: none;
            margin: 5px;
            display: inline-block;
            font-size: 15px;
            cursor: pointer;
        }
        .botoes button:hover,
        .botoes a:hover {
            background-color: #00509e;
        }
    </style>
</head>
<body>

<div class="botoes">
    <a href="painel_secretaria_geral.php">⬅ Voltar ao Painel</a>
</div>

<div class="recibo">
    <div class="cabecalho-escola">
        COMPLEXO ESCOLRAR BG 0026 PADRE EMIL FRICK - CATUMBELA
    </div>

    <img src="logo/logo.jpg" class="logo" alt="Logotipo da Escola" onerror="this.style.display='none'">

    <h2>Recibo de Pagamento de Propinas</h2>

    <div class="linha"><strong>Nome do Aluno:</strong> <?= htmlspecialchars($dados['nome_aluno']) ?></div>
    <div class="linha"><strong>Turma:</strong> <?= htmlspecialchars($dados['nome_turma'] ?? 'Não Informada') ?></div>
    <div class="linha"><strong>Curso:</strong> <?= htmlspecialchars($dados['curso_turma'] ?? 'Não Informado') ?></div>
    <div class="linha"><strong>Sala:</strong> <?= htmlspecialchars($dados['sala_turma'] ?? 'Não Informada') ?></div>
    <div class="linha"><strong>Classe:</strong> <?= htmlspecialchars($dados['classe_turma'] ?? 'Não Informada') ?></div>
    <div class="linha"><strong>Mês de Pagamento:</strong> <?= htmlspecialchars($dados['mes_pagamento'] ?? 'Não Informado') ?></div>
    <div class="linha"><strong>Valor Pago:</strong> <?= number_format($dados['valor_pago'], 2, ',', '.') ?> Kz</div>
    <div class="linha"><strong>Data do Pagamento:</strong> <?= date("d/m/Y H:i", strtotime($dados['data_pagamento'])) ?></div>
    <div class="linha"><strong>Status:</strong> <?= htmlspecialchars($dados['status']) ?></div>

    <div class="assinatura">
        <p><span class="texto-ass">Assinatura da Secretaria</span></p>
    </div>

    <div class="botoes">
        <button onclick="window.print()">🖨️ Imprimir Recibo</button>
    </div>
</div>

</body>
</html>